C     FORTRAN code: Example 10.3
C     File: forecast.for
C     Coded by: Paul De Bruin
C    
C     PROGRAM FOR COMPUTING THE APPROXIMATE MULTI-STEP AHEAD FORECASTS 
C
C     Reference:
C     De Gooijer, J.G. and De Bruin, P.T. (1998).
C        On forecasting SETAR processes.
C        Statistics & Probability Letters, 37(1), 7-14.
C        DOI: 10.1016/s0167-7152(97)00092-8. 
C     *****************************************************************    
C
      IMPLICIT REAL (A-H,O-Z)      
      REAL Z(30),SZ(30),SZ2(30),EZ(30),ESZ2(30)
      REAL ZZ(30)
      REAL PZ(30),QZ(30),FIZ(30),SQPI,PI,EZ3(30)
C     REAL EZ1(30),EZ2(30),EZ3(30),EZ4(30),EZ5(30),EZ6(30),EZ7(30)
      INTEGER H
C
      CHARACTER*50 FILE2,FILE4
C
C     **********     START INPUT SECTION          **********************
C
      FILE4='CON'
      OPEN(*,FILE='USER')
      OPEN(7,FILE=FILE4)
C
C     *********  PARAMETERS  ********
c
      DO 100 I=1,5
      WRITE(7,*)
 100  CONTINUE
      WRITE(7,*) '****************************************************'
      WRITE(7,*)
      WRITE(7,*) ' THIS PROGRAM COMPUTES THE APPROXIMATE MULTI-STEP-  '
      WRITE(7,*) ' AHEAD FORECASTS FOR SETMA(2;2,2) MODELS            '
      WRITE(7,*) ' WITH R=0, D=1                                      '
      WRITE(7,*) '****************************************************'
      WRITE(7,*)
C
 41   CONTINUE
      WRITE(*,'(A)')'  WHAT IS YOUR OUPUT FILE (FORMA22.OUT) ? '
      READ(*,'(A)') FILE2
C
      IF (FILE2.EQ.' ') THEN
      FILE2='FORMA22.OUT'
      END IF
      OPEN(6,FILE=FILE2)
C
      Z(1)=1.3
      Z0=1
      write(*,*) z(1)
C
      SZ2(1)=1
      SZ(1)=1
      var=1
C
      PI=3.14159265
C
C     PARAMETER VALUES OF THE 
C     THE SETAR(2;2,2) THRESHOLD MODEL WITH CONSTANTS AA0 AND BB0
C
C     FOR X{T-1} < 0 :
C
      AA0=0
      AA1=0.7
      aa2=-0.5
C
C     FOR X{T-1} > 0 :
C
      BB0=0
      BB1=0.3
      BB2=0.5
C
      WRITE(*,*) ' GIVE RHO:'
      READ(*,*) RHO
c     mu=.026
c     RHO=.54
      SIGMA2=1.37
C
      RHOA=AA1/(1-AA2)
      RHOB=BB1/(1-BB2)
C     RHO1=AA2/(1-AA2)
C     RHO2=BB2/(1-BB2)
C
C
      DO 1500 H=2,5
C
C***************************************************************
C     CUMULATIVE PROB OF NORMAL DISTRIBUTION APPROXIMATED
C     P(X < ZZ) FOR VALUES OF ZZ IN THE RANGE 0 <= ZZ < INFTY
C     SEE, E.G. ABRAMOWITZ AND STEGUN  P. 932
C***************************************************************
C
C     THE THRESHOLD C IS FIXED AT ZERO  
C
      a1=.0498673470
      a2=.0211410061
      a3=.0032776263
      a4=.0000380036
      a5=.0000488906
      a6=.0000053830
C
      IF(Z(H-1).LE.0) THEN
         ZZ(H-1)=-Z(H-1)/SQRT(SZ2(H-1))
         PZ(H-1)=1-0.5*(1+a1*ZZ(H-1)+a2*ZZ(H-1)*ZZ(H-1)
     1      +a3*ZZ(H-1)**3+a4*ZZ(H-1)**4
     2      +a5*ZZ(H-1)**5+a6*ZZ(H-1)**6)**(-16)
        QZ(H-1)=1-PZ(H-1)
      ELSE
         ZZ(H-1)=Z(H-1)/SQRT(SZ2(H-1))
         QZ(H-1)=1-0.5*(1+a1*ZZ(H-1)+a2*ZZ(H-1)*ZZ(H-1)
     1      +a3*ZZ(H-1)**3+a4*ZZ(H-1)**4
     2      +a5*ZZ(H-1)**5+a6*ZZ(H-1)**6)**(-16)
        PZ(H-1)=1-QZ(H-1)
       ENDIF
C
c******************************************************************
c
      sqpi=sqrt(2*pi)
      FIZ(H-1)=EXP((-ZZ(H-1)*ZZ(H-1))/2)/SQPI
       SZ(3)=1.422
       SZ2(3)=2.022
       SZ(4)=1.4
       SZ2(4)=1.96
C
C     IF(A2.EQ.0.AND.B2.EQ.0) THEN GOTO  9999
      IF(H.EQ.2) THEN
C
      write(*,*) z(1)
       EZ(2)=(AA0+AA1*Z(1)+AA2*Z0)*PZ(1)
     1 +(BB0+BB1*Z(1)+BB2*Z0)*QZ(1)
     2 +(BB1-AA1)*sqrt(SZ2(1))*FIZ(H-1)
       Z(2)=EZ(2)
      WRITE(*,*) 'Z(2) =',Z(2)
c
      ESZ2(2)=
     1  (AA0*AA0+AA1*AA1*SZ2(1)+2*AA0*AA1*Z(1)
     2 + AA1*AA1*Z(1)*Z(1)+AA2*AA2*Z0*Z0)*PZ(1)
     3 +(BB0*BB0+BB1*BB1*SZ2(1)+2*BB0*BB1*Z(1)
     4 + BB1*BB1*Z(1)*Z(1)+BB2*BB2*Z0*Z0)*QZ(1)
     5 +var-Z(2)*Z(2)
     6 +(BB1*BB1*SZ2(1)*ZZ(H-1)+2*BB1*SQRT(SZ2(1))*(BB0+
     7       BB1*Z(1)+BB2*Z0))*FIZ(H-1)
     8 -(AA1*AA1*SZ2(1)*ZZ(H-1)+2*AA1*SQRT(SZ2(1))*(AA0+
     9       AA1*Z(1)+AA2*Z0))*FIZ(H-1)
C
       CC1=2*AA1*AA2*1
       DD1=2*BB1*BB2*1
C
       EZ(2)=(AA0+CC1*Z(1))*PZ(1)
     1 +(BB0+DD1*Z(1))*QZ(1)
     2 +(DD1-CC1)*sqrt(SZ2(1))*FIZ(H-1)
C
       ESZ2(2)=ESZ2(2)+EZ(2)  
       sz2(2)=esz2(2)
C
       SZ(2)=SQRT(ESZ2(2))
C
       WRITE(*,*) ' Z(1),Z(2) AND SZ(1), SZ(2)',Z(1),Z(2),SZ(1),SZ(2)
C
       ELSE
c
C     THE FORECAST:
C     Z(H) IS THE FORECAST FOR SETAR(2;1,1) MODEL
C
       WRITE(*,*) ' FOR H > 2: ',H
C
       Z(H)=(aa1*Z(H-1)+aa2*z(1))*pZ(H-1)
     1    + (bb1*Z(H-1)+bb2*z(1))*qZ(H-1)
     2 +(bb1-aa1)*sqrt(SZ2(H-1))*FIZ(H-1)
     3 +(bb2-aa2)*sqrt(sz2(1))*fiz(1)
c    4 + bb2*z(h-2)*qz(h-1)
c    1     +(bb1*Z(H-1)+bb2*z(h-2))*QZ(H-1)
C
      WRITE(*,*)'Z SZ',Z(H),SZ(H)
c
C*******************************************

      ESZ2(H)=
     1  (AA0*AA0+AA1*AA1*SZ2(H-1)+2*AA0*AA1*Z(H-1)
     2 + AA1*AA1*Z(H-1)*Z(H-1)+AA2*AA2*Z(H-2)*Z(H-2))*PZ(H-1)
     3 +(BB0*BB0+BB1*BB1*SZ2(H-1)+2*BB0*BB1*Z(H-1)
     4 + BB1*BB1*Z(H-1)*Z(H-1)+BB2*BB2*Z(H-2)*Z(H-2))*QZ(H-1)
     5 +var-Z(H)*Z(H)
     6 +(BB1*BB1*SZ2(H-1)*ZZ(H-2)+2*BB1*SQRT(SZ2(H-1))*(BB0+
     7       BB1*Z(H-1)+BB2*Z(H-2)))*FIZ(H-2)
     8 -(AA1*AA1*SZ2(H-1)*ZZ(H-2)+2*AA1*SQRT(SZ2(H-1))*(AA0+
     9       AA1*Z(H-1)+AA2*Z(H-2)))*FIZ(H-2)
C
       CC1=2*AA1*AA2*Z(H-1)
       DD1=2*BB1*BB2*Z(H-1)
C
       EZ(H)=(AA0+CC1*Z(H-1))*PZ(H-1)
     1 +(BB0+DD1*Z(H-1))*QZ(H-1)
     2 +(DD1-CC1)*sqrt(SZ2(H-1))*FIZ(H-2)
C
       ESZ2(H)=ESZ2(H)+EZ(H)  
       sz2(H)=esz2(H)
C
       SZ(H)=SQRT(ESZ2(H))

C*********************************************************

C     ESZ2(H)=
C    1  (AA0*AA0+AA1*AA1*SZ2(H-1)+2*AA0*AA1*Z(H-1)
C    2     + AA1*AA1*Z(H-1)*Z(H-1))*PZ(H-1)
C    3 +(BB0*BB0+BB1*BB1*SZ2(H-1)+2*BB0*BB1*Z(H-1)
C    4     + BB1*BB1*Z(H-1)*Z(H-1))*QZ(H-1)
C    5 +var-Z(H)*Z(H)
C    6 +(BB1*BB1*SZ2(H-1)*ZZ(H-1)+2*BB1*SQRT(SZ2(H-1))*(BB0+
C    7       BB1*Z(H-1)))*FIZ(H-1)
C    8 -(AA1*AA1*SZ2(H-1)*ZZ(H-1)+2*AA1*SQRT(SZ2(H-1))*(AA0+
C    9       AA1*Z(H-1)))*FIZ(H-1)
C
C     EZ(H)=
C    1  (AA0*AA0+AA2*AA2*SZ2(H-2)+2*AA0*AA2*Z(H-2)
C    2     + AA2*AA2*Z(H-2)*Z(H-2))*PZ(H-2)
C    3 +(BB0*BB0+BB2*BB2*SZ2(H-2)+2*BB0*BB2*Z(H-2)
C    4     + BB2*BB2*Z(H-2)*Z(H-2))*QZ(H-2)
C    5 +var
C    6 +(BB2*BB2*SZ2(H-2)*ZZ(H-2)+2*BB2*SQRT(SZ2(H-2))*(BB0+
C    7       BB2*Z(H-2)))*FIZ(H-2)
C    8 -(AA2*AA2*SZ2(H-2)*ZZ(H-2)+2*AA2*SQRT(SZ2(H-2))*(AA0+
C    9       AA2*Z(H-2)))*FIZ(H-2)
C
C      CC1=2*AA1*AA2*(AA1*Z(H-1)+AA2*Z0*Z(H-1))
C      DD1=2*BB1*BB2*(BB1*Z(H-1)+BB2*Z0*Z(H-1))
C
C      EZ3(H)=(AA0+CC1*Z(H-1))*PZ(H-1)
C    1 +(BB0+DD1*Z(H-1))*QZ(H-1)
C    2 +(DD1-CC1)*sqrt(SZ2(1))*FIZ(H-1)

C
C      SZ2(H)=EZ(H)+ESZ2(H)+EZ3(H)
C
       SZ(H)=SQRT(SZ2(H))
       WRITE(*,*) 'H, SZ(H)', H, SZ(H)
C
       SZ(3)=1.422
       SZ2(3)=2.022
       SZ(4)=1.4
       SZ2(4)=1.96
C
C      WRITE(*,*) ' FOR H >2', H
C      WRITE(*,*) ' Z(H), AND SZ(H)',Z(H),SZ(H)
C

       ENDIF
C
 1500 CONTINUE
C

C     WRITE(6,*) '      FORECASTS '
C     WRITE(6,*) ' **************************************************'
C     WRITE(6,*) '          H       FOREC         SD '
C     DO 1501 H=1,15
C     WRITE(6,*) H, Z(H), SZ(H)
C1501 CONTINUE
C
      END
